IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL];
GO

GO
--EXEC P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL
/*
	Esta procedure roda dentro da P_ATUALIZA_AGENDA_SUPRIMENTO
*/
CREATE PROCEDURE P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL @CD_EMP INT=1
WITH ENCRYPTION
AS
    SET NOCOUNT ON;
	CREATE TABLE #RsCancelada (CD_EMP INT,
							   CD_FILIAL INT,
							   CD_PG_CRED INT)
    DECLARE @CD_CTR INT
    BEGIN TRY
	    PRINT 'Deletando pendencia de duplicata sem vinculo com nota fiscal  (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
		DELETE 
			P 
		FROM
			PG_CRED_PROC_PENDENCIA p INNER JOIN PG_CRED d  ON
			d.CD_EMP = p.CD_EMP AND
			d.CD_FILIAL = p.CD_FILIAL AND
			d.CD_PG_CRED = p.CD_PG_CRED 
			LEFT OUTER JOIN PG_CRED_EST_NF_ENT rs ON
			rs.CD_EMP = d.CD_EMP AND
			rs.CD_FILIAL = d.CD_FILIAL AND
			rs.NR_DP = d.NR_DP AND
			rs.ANO = d.ANO 
		WHERE
			p.STS_DP =0
			AND rs.CD_FILIAL IS NULL

	   DECLARE CCompradorCarga CURSOR FAST_FORWARD FOR
		  SELECT
			 CD_CTR
		  FROM
			 PG_CRED_PROC_PENDENCIA
		  WHERE
			STS_DP=3;

	   OPEN CCompradorCarga;
	   FETCH NEXT FROM CCompradorCarga INTO @CD_CTR;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT 'Cancelando duplicata Controle ' + CONVERT(VARCHAR(max), @CD_CTR) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

			 EXEC P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_CANCELAMENTO  @CD_CTR
			 
			 DELETE FROM PG_CRED_PROC_PENDENCIA WHERE CD_CTR = @CD_CTR

			 FETCH NEXT FROM CCompradorCarga INTO @CD_CTR ;
		  END ;

	   CLOSE CCompradorCarga ;
	   DEALLOCATE CCompradorCarga ;
	   
	   -- A Ordem by foi criada para seguir a cronologia da criacao dos registros	
	   DECLARE CCompradorCarga CURSOR FAST_FORWARD FOR
		  SELECT
			 CD_CTR
		  FROM
			 PG_CRED_PROC_PENDENCIA
		  ORDER BY
			 CD_CTR;

	   OPEN CCompradorCarga;
	   FETCH NEXT FROM CCompradorCarga INTO @CD_CTR;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT 'Controle ' + CONVERT(VARCHAR(max), @CD_CTR) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

			 EXEC P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR @CD_EMP, @CD_CTR
			 
			 DELETE FROM PG_CRED_PROC_PENDENCIA WHERE CD_CTR = @CD_CTR

			 FETCH NEXT FROM CCompradorCarga INTO @CD_CTR ;
		  END ;

	   CLOSE CCompradorCarga ;
	   DEALLOCATE CCompradorCarga ;

	END TRY
    BEGIN CATCH

		CLOSE CCompradorCarga ;
		DEALLOCATE CCompradorCarga ;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;
    
    

